#include <PS2Keyboard.h>
#include <Servo.h>
#include "pitches.h"

//////////////////////// Constants ///////////////////////////////////

//digital pin for outputing tone PWM
const int SERVO_PIN = 10;
//digital pin for outputing tone PWM
const int TONE_PIN = 9;
//digital pin for reading PS2 data
const int DATA_PIN = 8;
//external interupt accociated with pin connected to PS2 clock signal
//Pin 2
const int CLK_IRQ = 0;

//melody to play on power up
const int START_MELODY_LEN=8;
const int START_MELODY[START_MELODY_LEN] = {
  NOTE_C4, NOTE_G3,NOTE_G3, NOTE_A3, NOTE_G3,0, NOTE_B3, NOTE_C4};
// note durations: 4 = quarter note, 8 = eighth note, etc.:
const int START_MELODY_DURATION[START_MELODY_LEN] = {4, 8, 8, 4, 4, 4, 4, 4};
//melody to play on failed unlock
const int FAIL_MELODY_LEN=2;
const int FAIL_MELODY[FAIL_MELODY_LEN] = { NOTE_A1, NOTE_F1};
const int FAIL_MELODY_DURATION[FAIL_MELODY_LEN] = {2, 2};
//melody to play on successful unlock
const int UNLOCK_MELODY_LEN=2;
const int UNLOCK_MELODY[UNLOCK_MELODY_LEN] = { NOTE_F5, NOTE_A5};
const int UNLOCK_MELODY_DURATION[UNLOCK_MELODY_LEN] = {2, 2};
//melody to play on successful lock
const int LOCK_MELODY_LEN=2;
const int LOCK_MELODY[LOCK_MELODY_LEN] = { NOTE_A5, NOTE_F5};
const int LOCK_MELODY_DURATION[LOCK_MELODY_LEN] = {2, 2};

//Key combination to unlock safe
const int PASS_KEY_LEN=6;
const char PASS_KEYS[PASS_KEY_LEN]={'1','2','0','0','0','2'} ; 

//angle that servo is in when safe is openned
const int SERVO_UNLOCK_ANGLE = 135;
//angle that servo is in when safe is closed
const int SERVO_LOCK_ANGLE = 90;

//////////////////// Global Variables ////////////////////////////////

//which key in the password is currently being entered
int index=0;
//true if all keys match password so far
bool goodSoFar=true;
//true if safe is openned
bool opened=false;
//PS2 keyboard interface
PS2Keyboard keyboard;
// create servo object to control a servo
Servo myservo;

//////////////////// Functions ////////////////////////////
 
 
/*
* Plays a single note 
*/
void PlayTone(const int note, const int duration)
{
    
    // to calculate the note duration, take one second 
    // divided by the note type.
    //e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.
    int noteDuration = 1000/duration;
    tone(TONE_PIN, note,noteDuration);

    // to distinguish the notes, set a minimum time between them.
    // the note's duration + 30% seems to work well:
    int pauseBetweenNotes = noteDuration * 1.30;
    delay(pauseBetweenNotes);
    // stop the tone playing:
    noTone(TONE_PIN);
    
}

/*
* Plays a series of notes 
*/
void PlayMelody(const int * melody, const int * duration, const int numNotes)
{
    for(int i=0;i<numNotes;i++)
    {
      PlayTone(melody[i], duration[i]);
    }
}

void setup() {
  //initialize keyboard
  keyboard.begin(DATA_PIN, CLK_IRQ, PS2Keymap_US);
  //Set up serial for debugging
  Serial.begin(9600);
  Serial.println("Lock Test:");
  //Play start tone
  PlayMelody(START_MELODY, START_MELODY_DURATION,START_MELODY_LEN);
}

void loop() {
  //if a key has been pressed since last check
  if (keyboard.available()) {
    //get next key press
    char c = keyboard.read();
    Serial.println(c);
    //play tone for pressed key
    int note;
    switch(c)
    {
     case '0':
       note=NOTE_A3;
       break;
     case '1':
       note=NOTE_B3;
       break;
      case '2':
       note=NOTE_C3;
       break;
      case '3':
       note=NOTE_D3;
       break;
      case '4':
       note=NOTE_E3;
       break;
      case '5':
       note=NOTE_F3;
       break;
      case '6':
       note=NOTE_A4;
       break;
      case '7':
       note=NOTE_B4;
       break;
      case '8':
       note=NOTE_C4;
       break;
      case '9':
       note=NOTE_D4;
       break; 
      default:
          note=NOTE_E4;    
    }
    PlayTone(note,4);
    
    //if key is incorrect set goodSoFar false
    if(PASS_KEYS[index]!=c)
    {
      goodSoFar=false;
    }
    //increment index
    index++;
    //if the full password has been entered
    if(index==PASS_KEY_LEN)
    {
      //if its good switch lock state
      if(goodSoFar)
      {
        if(opened)
        {
           Serial.println("Lock");
           PlayMelody(LOCK_MELODY, LOCK_MELODY_DURATION, LOCK_MELODY_LEN);
           myservo.write(SERVO_LOCK_ANGLE);
           myservo.attach(SERVO_PIN);
           delay(500);
           myservo.detach();
        }
        else
        {
            Serial.println("Unlock");
            PlayMelody(UNLOCK_MELODY, UNLOCK_MELODY_DURATION, UNLOCK_MELODY_LEN);
            myservo.write(SERVO_UNLOCK_ANGLE);
            myservo.attach(SERVO_PIN);
            delay(500);
            myservo.detach();
        } 
        opened=!opened;
      }
      else
      {
          Serial.println("Fail");
          PlayMelody(FAIL_MELODY, FAIL_MELODY_DURATION, FAIL_MELODY_LEN);
      }
      //reset state for next password attempt
      goodSoFar=true;
      index=0;
    }
  }
}
